/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.vlan.eui;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class VlanMacBasePanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "Vlan MAC";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel IbmVlanMacConf_model;
    protected selectionListSection selectionListPropertySection;
    protected IbmVlanMacDetailsSection IbmVlanMacDetailsPropertySection;
    protected ModelInfo VlanMacTableInfo;
    protected ModelInfo PanelInfo;
    protected int VlanMacTableIndex;
    protected VlanMacTable VlanMacTableData;
    protected TableColumns VlanMacTableColumns;
    protected TableStatus VlanMacTableStatus;
    protected static TableColumn[] VlanMacTableCols = new TableColumn[]{new TableColumn("Index.IbmVlanConfIndex", "VLAN Index", 3, true), new TableColumn("Index.IbmVlanMacAddrIndex", "MAC Address", 3, true)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.vlan.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.vlan.eui.VlanMacBasePanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel VlanMacBase");
        }
    }

    public static String getTitle() {
        VlanMacBasePanel.loadStatics();
        if (myResources != null) {
            title = VlanMacBasePanel.getNLSString("VlanMacBasePanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            VlanMacBasePanel.loadStatics();
        }
        return enumStrings;
    }

    public VlanMacBasePanel() {
        VlanMacBasePanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return VlanMacBasePanel.getTitle();
    }

    protected void getModels() {
        this.IbmVlanMacConf_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addIbmVlanMacDetailsSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(VlanMacBasePanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addIbmVlanMacDetailsSection() {
        this.IbmVlanMacDetailsPropertySection = new IbmVlanMacDetailsSection();
        this.IbmVlanMacDetailsPropertySection.layoutSection();
        this.addSection(VlanMacBasePanel.getNLSString("IbmVlanMacDetailsSectionTitle"), this.IbmVlanMacDetailsPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.IbmVlanMacDetailsPropertySection != null) {
            this.IbmVlanMacDetailsPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialVlanMacTableRow() {
        return 0;
    }

    public ModelInfo initialVlanMacTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(VlanMacBasePanel.getNLSString("startResetMsg"));
        this.VlanMacTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(VlanMacBasePanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(VlanMacBasePanel.getNLSString("endResetMsg")) + " " + VlanMacBasePanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.IbmVlanConfIndex", (Serializable)this.VlanMacTableData.getValueAt("Index.IbmVlanConfIndex", this.VlanMacTableIndex));
        this.PanelInfo.add("Index.IbmVlanMacAddrIndex", (Serializable)this.VlanMacTableData.getValueAt("Index.IbmVlanMacAddrIndex", this.VlanMacTableIndex));
        this.errorsFound = false;
        this.displayMsg(VlanMacBasePanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.VlanMacTableInfo = (ModelInfo)this.VlanMacTableData.elementAt(this.VlanMacTableIndex);
            this.VlanMacTableInfo = this.VlanMacTableData.setRow();
            this.VlanMacTableData.setElementAt(this.VlanMacTableInfo, this.VlanMacTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(VlanMacBasePanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(VlanMacBasePanel.getNLSString("endApplyMsg")) + " " + VlanMacBasePanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(VlanMacBasePanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.VlanMacTableData = new VlanMacTable();
        this.VlanMacTableIndex = 0;
        this.VlanMacTableColumns = new TableColumns(VlanMacTableCols);
        if (this.IbmVlanMacConf_model instanceof RemoteModelWithStatus) {
            try {
                this.VlanMacTableStatus = (TableStatus)this.IbmVlanMacConf_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component VlanMacTableField;
        Label VlanMacTableFieldLabel;
        boolean VlanMacTableFieldWritable = false;

        public selectionListSection() {
            VlanMacBasePanel.this = VlanMacBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createVlanMacTableField() {
            EuiGrid euiGrid = new EuiGrid(VlanMacBasePanel.this.VlanMacTableData, VlanMacBasePanel.this.VlanMacTableColumns, false);
            euiGrid.addRows(3);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(VlanMacBasePanel.this.initialVlanMacTableRow());
            this.addTable(VlanMacBasePanel.getNLSString("VlanMacTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.VlanMacTableField = this.createVlanMacTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                VlanMacBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("accessDataMsg"));
            VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.VlanMacTableField).refresh();
            VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("endTableGetMsg"));
            VlanMacBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.VlanMacTableField) {
                        VlanMacBasePanel.this.VlanMacTableIndex = euiGridEvent.getRow();
                    }
                    VlanMacBasePanel.this.VlanMacTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.VlanMacTableField).deselectAllRows();
                    VlanMacBasePanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.VlanMacTableField) {
                        VlanMacBasePanel.this.VlanMacTableIndex = 0;
                    }
                    VlanMacBasePanel.this.selectionListPropertySection.reset();
                    VlanMacBasePanel.this.IbmVlanMacDetailsPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class IbmVlanMacDetailsSection
    extends PropertySection {
        ModelInfo chunk;
        Component ibmVlanMacAddressesField;
        Label ibmVlanMacAddressesFieldLabel;
        boolean ibmVlanMacAddressesFieldWritable = false;

        public IbmVlanMacDetailsSection() {
            VlanMacBasePanel.this = VlanMacBasePanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createibmVlanMacAddressesField() {
            String string = VlanMacBasePanel.this.getOverride("ibm.nways.vlan.model.IbmVlanMacConf.Panel.IbmVlanMacAddresses.access", "read-only");
            VlanMacBasePanel.this.getOverride("ibm.nways.vlan.model.IbmVlanMacConf.Panel.IbmVlanMacAddresses.length", "600");
            this.ibmVlanMacAddressesFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.ibmVlanMacAddressesFieldLabel = new Label(VlanMacBasePanel.getNLSString("ibmVlanMacAddressesLabel"), 2);
            if (this.ibmVlanMacAddressesFieldWritable) {
                StringInputRO stringInputRO = new StringInputRO();
                this.addRow(this.ibmVlanMacAddressesFieldLabel, (Component)stringInputRO);
                VlanMacBasePanel.this.containsWritableField = true;
                return stringInputRO;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.ibmVlanMacAddressesFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getibmVlanMacAddressesField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ibmVlanMacAddressesField);
            this.validateibmVlanMacAddressesField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setibmVlanMacAddressesField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.ibmVlanMacAddressesField);
                jDMInput.setValue(object);
                this.validateibmVlanMacAddressesField();
            }
        }

        protected boolean validateibmVlanMacAddressesField() {
            JDMInput jDMInput = (JDMInput)((Object)this.ibmVlanMacAddressesField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.ibmVlanMacAddressesFieldLabel.setForeground(Color.yellow);
            } else {
                this.ibmVlanMacAddressesFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.ibmVlanMacAddressesField = this.createibmVlanMacAddressesField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.ibmVlanMacAddressesField)).ignoreValue() && this.ibmVlanMacAddressesFieldWritable) {
                    VlanMacBasePanel.this.PanelInfo.add("Panel.IbmVlanMacAddresses", this.getibmVlanMacAddressesField());
                    return;
                }
            } else {
                VlanMacBasePanel.this.errorsFound = true;
            }
        }

        public void reset() {
            VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("accessDataMsg"));
            try {
                this.setibmVlanMacAddressesField(VlanMacBasePanel.this.VlanMacTableData.getValueAt("Panel.IbmVlanMacAddresses", VlanMacBasePanel.this.VlanMacTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            VlanMacBasePanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setibmVlanMacAddressesField(VlanMacBasePanel.this.VlanMacTableData.getValueAt("Panel.IbmVlanMacAddresses", VlanMacBasePanel.this.VlanMacTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }
    }

    public class VlanMacTable
    extends Table {
        public ModelInfo setRow() {
            try {
                VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("startSendMsg"));
                VlanMacBasePanel.this.PanelInfo = VlanMacBasePanel.this.IbmVlanMacConf_model.setInfo("Panel", VlanMacBasePanel.this.PanelInfo);
                VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("endSendMsg"));
                if (VlanMacBasePanel.this.PanelInfo != null) {
                    Enumeration enumeration = VlanMacBasePanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = VlanMacBasePanel.this.PanelInfo.get(string);
                        VlanMacBasePanel.this.VlanMacTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return VlanMacBasePanel.this.VlanMacTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    VlanMacBasePanel.this.VlanMacTableInfo = null;
                    VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("startRow"));
                    VlanMacBasePanel.this.PanelInfo = VlanMacBasePanel.this.IbmVlanMacConf_model.getNextInfo("Panel", "default", modelInfo);
                    VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("endRow"));
                    if (VlanMacBasePanel.this.PanelInfo != null) {
                        VlanMacBasePanel.this.VlanMacTableInfo = new ModelInfo();
                        if (VlanMacBasePanel.this.PanelInfo.isBeingMonitored()) {
                            VlanMacBasePanel.this.VlanMacTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = VlanMacBasePanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = VlanMacBasePanel.this.PanelInfo.get(string);
                            VlanMacBasePanel.this.VlanMacTableInfo.add(string, serializable);
                        }
                    }
                    if (VlanMacBasePanel.this.VlanMacTableInfo != null && !this.validRow(VlanMacBasePanel.this.VlanMacTableInfo)) {
                        modelInfo = VlanMacBasePanel.this.VlanMacTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return VlanMacBasePanel.this.VlanMacTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            VlanMacBasePanel.this.VlanMacTableInfo = null;
            try {
                VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("startRow"));
                VlanMacBasePanel.this.PanelInfo = VlanMacBasePanel.this.IbmVlanMacConf_model.getInfo("Panel", "default", modelInfo);
                VlanMacBasePanel.this.displayMsg(VlanMacBasePanel.getNLSString("endRow"));
                if (VlanMacBasePanel.this.PanelInfo != null) {
                    VlanMacBasePanel.this.VlanMacTableInfo = new ModelInfo();
                    if (VlanMacBasePanel.this.PanelInfo.isBeingMonitored()) {
                        VlanMacBasePanel.this.VlanMacTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = VlanMacBasePanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = VlanMacBasePanel.this.PanelInfo.get(string);
                        VlanMacBasePanel.this.VlanMacTableInfo.add(string, serializable);
                    }
                }
                if (VlanMacBasePanel.this.VlanMacTableInfo != null && !this.validRow(VlanMacBasePanel.this.VlanMacTableInfo)) {
                    VlanMacBasePanel.this.VlanMacTableInfo = this.getRow(VlanMacBasePanel.this.VlanMacTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return VlanMacBasePanel.this.VlanMacTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (VlanMacBasePanel.this.VlanMacTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            VlanMacBasePanel.this.VlanMacTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        VlanMacBasePanel.this.VlanMacTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        VlanMacBasePanel.this.VlanMacTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    VlanMacBasePanel.this.VlanMacTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            return string2;
        }

        public VlanMacTable() {
            VlanMacBasePanel.this = VlanMacBasePanel.this;
        }
    }
}

